<?php
// Simple Load Average Monitor for Linux // April 11, 2013 Deer Creek Enterprise Limited // http://www.deer-creek.ca 
// Lewcy @ Webhostingtalk.com
// Build for MyBB 1.6.x by Yiihaa @mybbindonesia.com

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("global_start", "cpu_load");

function cpuload_info()
{
	return array(
		"name"			=> "Monitor Server CPU Load On Your Forum",
		"description"	=> "Displaying averages CPU Load of your server on footer forum in any page. This useful to monitor your server or shared-webhosting performance, especially when you're checking new installed plugin. And give you ability to send email alert, if specified CPU Load was reach.",
		"website"		=> "http://mybbindonesia.com",
		"author"		=> "Yiihaa",
		"authorsite"	=> "http://komunitas.mybbindonesia.com",
		"version"		=> "1.0",
		"guid" 			=> "ec01fd601817adb3a5af7741baef85ab",
		"compatibility" => "16*"
	);
}

// Plugin activation
function cpuload_activate()
{
	global $db, $mybb, $template;
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	
	find_replace_templatesets("footer", "#".preg_quote('<debugstuff>')."#i", '{$MyLoadServer}<debugstuff>');
}

// Plugin deactivation
function cpuload_deactivate()
{
	global $db, $mybb;
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("footer", "#".preg_quote('{$MyLoadServer}<debugstuff>')."#i", '<debugstuff>');
}

// Plugin main function
function cpu_load()
{
global $mybb, $MyLoadServer;

// Set it carefully, or you will received many emails alert each time this program run
// Before set, please monitor your DAHSBOARD admin for Server Load at peak time (eg.10AM - 2PM or 6PM - 9PM)
$min_warn_level = 5.0; // Set to min load average to send alert, eg. 1 = Single CPU server utilize or 4 = Quad Core
$email_recipient = "your_email@forum.com"; // Set to address of alert recipient (do not use this for abuse)

// Main Program Do Not Edit
$current_reading = @exec('uptime'); 
preg_match("/averages?: ([0-9\.]+),[\s]+([0-9\.]+),[\s]+([0-9\.]+)/", $current_reading, $averages); 
$uptime = explode(' up ', $current_reading); 
$uptime = explode(',', $uptime[1]); 
$uptime = $uptime[0].', Last Check Time' . $uptime[1]; 

// Data to be sent for email alert if CPU Load trigger level was reach
$dataMail = "Server Load Averages $averages[1], $averages[2], $averages[3] \nServer Uptime $uptime"; 
if ($averages[3] > $min_warn_level )
{
$subject = "Alert: Load average is over $min_warn_level"; mail($email_recipient, $subject, $dataMail); 
}

// Safety mail trigger
if ($email_recipient == "your_email@forum.com")
{
die('<strong><h1>Safety Trigger is ON</h1></strong><br /><i>Change & fill your email! Please edit file <strong>cpuload.php</strong> in plugin folder, before activated this plugin. Check variable $email_recipient at Line: 52!!</i><br />');
}

// Displayed on any pages via footer template
$MyLoadServer = "<i>Server Load Averages (1, 5, 15 minutes) $averages[1], $averages[2], $averages[3]<br />"; 
$MyLoadServer .= "Server Uptime $uptime</i><br /><br />"; 
}

?>